// PageSettingSystem.cpp : implementation file
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "PageSettingSystem.h"
#include "Include\CommonFun.h"
#include "Include\CLS_NVDSDK_Interface.h"
#include "DecCtrlClientTypes.h"

// CPageSettingSystem dialog
#define UPDATE_TIME 0

IMPLEMENT_DYNAMIC(CPageSettingSystem, CDialog)

CPageSettingSystem::CPageSettingSystem(CWnd* pParent /*=NULL*/)
	: CLS_CBasePage(CPageSettingSystem::IDD, pParent)
{
    m_pDecParam = NULL;
	m_bVGAListDown = false;
}

CPageSettingSystem::~CPageSettingSystem()
{
	if (m_dlgUpgrade.m_hWnd)
	{
		m_dlgUpgrade.EndDialog(0);
	}
}

void CPageSettingSystem::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_CHANNEL, m_CboChannel);
	DDX_Control(pDX, IDC_COMBO_SYSCHANNEL, m_CboSysChannel);
	DDX_Control(pDX, IDC_COMBO_VGASIZE, m_CboVGASize);
	DDX_Control(pDX, IDC_COMBO_VIDEOMODE, m_CboVidemoMode);
	DDX_Control(pDX, IDC_COMBO_LANGUAGE, m_CboLanguage);
	DDX_Control(pDX, IDC_EDIT_UPGRADESYSTEM, m_EditUpgradeFile);
	DDX_Control(pDX, IDC_EDIT_UPGRADEWEB, m_EditUpgradeWebFile);
	DDX_Control(pDX, IDC_COMBO_PIC, m_CboPic);
	DDX_Control(pDX, IDC_EDIT_PLAN_ALIAS, m_edtOtherName);
	//DDX_Control(pDX, IDC_EDIT_AUDIOSET, m_EditAudio);

	DDX_Control(pDX, IDC_COMBO_PREFERENCE, m_cboPreference);
	DDX_Control(pDX, IDC_SLIDER_VOLUME, m_sldVolume);
	DDX_Control(pDX, IDC_CHECK_NETCUT_RESERVE_LATFRAME, m_chkLastFrame);
	DDX_Control(pDX, IDC_COMBO_TIMEZONE, m_cboTimeZone);
	DDX_Control(pDX, IDC_COMBO_PLAN, m_cbbPlan);
	DDX_Control(pDX, IDC_CBO_SHOW_NOT_ON_LINE, m_cboShowNotLogonChannel);
	DDX_Control(pDX, IDC_CHECK_4K_HD_DISPLAY, m_chkHDDisplay);
	DDX_Control(pDX, IDC_CHECK_TELNET, m_chkTelnet);
}


BEGIN_MESSAGE_MAP(CPageSettingSystem, CDialog)
	ON_BN_CLICKED(IDC_BUTTON_SETPIC, &CPageSettingSystem::OnBnClickedButtonSetpic)
	ON_BN_CLICKED(IDC_BUTTON_BROWSEUPGRADESYSTEM, &CPageSettingSystem::OnBnClickedButtonBrowseupgradesystem)
	ON_CBN_SELCHANGE(IDC_COMBO_CHANNEL, &CPageSettingSystem::OnCbnSelchangeComboChannel)
	ON_CBN_SELCHANGE(IDC_COMBO_VGASIZE, &CPageSettingSystem::OnCbnSelchangeComboVGASize)
	ON_CBN_SELCHANGE(IDC_COMBO_VIDEOMODE, &CPageSettingSystem::OnCbnSelchangeComboVideoMode)
	ON_CBN_SELCHANGE(IDC_COMBO_LANGUAGE, &CPageSettingSystem::OnCbnSelchangeComboLanguage)
	ON_BN_CLICKED(IDC_BUTTON_SETAUDIO, &CPageSettingSystem::OnBnClickedButtonSetaudio)
	ON_BN_CLICKED(IDC_BUTTON_BROWSEUPGRADEWEB, &CPageSettingSystem::OnBnClickedButtonBrowseupgradeweb)
	ON_BN_CLICKED(IDC_BUTTON_UPGRADESYSTEM, &CPageSettingSystem::OnBnClickedButtonUpgradesystem)
	ON_BN_CLICKED(IDC_BUTTON_UPGRADEWEB, &CPageSettingSystem::OnBnClickedButtonUpgradeweb)
	ON_CBN_DROPDOWN(IDC_COMBO_VGASIZE, &CPageSettingSystem::OnCbnDropdownComboVgasize)
	ON_CBN_CLOSEUP(IDC_COMBO_VGASIZE, &CPageSettingSystem::OnCbnCloseupComboVgasize)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER_VOLUME, &CPageSettingSystem::OnNMCustomdrawSliderVolume)
	ON_CBN_SELCHANGE(IDC_COMBO_PREFERENCE, &CPageSettingSystem::OnCbnSelchangeComboPreference)
	ON_BN_CLICKED(IDC_CHECK_NETCUT_RESERVE_LATFRAME, &CPageSettingSystem::OnBnClickedCheckNetCutReserveLastFrame)
	ON_WM_CLOSE()
	ON_CBN_SELCHANGE(IDC_COMBO_SYSCHANNEL, &CPageSettingSystem::OnCbnSelchangeComboSyschannel)
	ON_BN_CLICKED(IDC_BUTTON_TIME, &CPageSettingSystem::OnBnClickedButtonTime)
	ON_WM_SHOWWINDOW()
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON_DEFAULT, &CPageSettingSystem::OnBnClickedButtonDefault)
	ON_CBN_SELCHANGE(IDC_COMBO_TIMEZONE, &CPageSettingSystem::OnCbnSelchangeComboTimezone)
	ON_BN_CLICKED(IDC_BUTTON_SHOWVONO, &CPageSettingSystem::OnBnClickedButtonShowvono)
	ON_CBN_SELCHANGE(IDC_COMBO_PLAN, &CPageSettingSystem::OnCbnSelchangeComboPlan)
	ON_BN_CLICKED(IDC_BUTTON_PLAN_APPLY, &CPageSettingSystem::OnBnClickedButtonPlanApply)
	ON_BN_CLICKED(IDC_BUTTON_PALN_SET, &CPageSettingSystem::OnBnClickedButtonPalnSet)
	ON_BN_CLICKED(IDC_BUTTON_PLAN_SAVE, &CPageSettingSystem::OnBnClickedButtonPlanSave)
	ON_BN_CLICKED(IDC_BUTTON_EXPORT, &CPageSettingSystem::OnBnClickedButtonExport)
	ON_CBN_SELCHANGE(IDC_CBO_SHOW_NOT_ON_LINE, &CPageSettingSystem::OnCbnSelchangeCboShowNotOnLine)
	ON_BN_CLICKED(IDC_CHECK_4K_HD_DISPLAY, &CPageSettingSystem::OnBnClickedCheck4kHdDisplay)
	ON_BN_CLICKED(IDC_BTN_REBOOTRADE, &CPageSettingSystem::OnBnClickedBtnRebootrade)
	ON_BN_CLICKED(IDC_CHECK_TELNET, &CPageSettingSystem::OnBnClickedCheckTelnet)
END_MESSAGE_MAP()

static char csVGA[][255]={
	"",
	"800*600 60Hz",//1
	"1024*768 60Hz",
	"1280*1024 60Hz",
	"1280*720P 60Hz",
	"1920*1080P 60Hz",
	"1280*720P 50Hz",
	"1920*1080P 50Hz",
	"1920*1080I 60Hz",
	"1920*1080I 50Hz",
	"1366*768 60Hz",
	"1440*900 60Hz",
	"1280*800 60Hz",
	"2560*1600 30Hz",
	"3840*2160 30Hz",
	"3840*2160 60Hz"//15
};

// CPageSettingSystem message handlers
void  CPageSettingSystem::LoadSurfaceResource()
{
    m_CboLanguage.AddString(GetText(IDS_SETTING_CHINESE));
	m_CboLanguage.AddString(GetText(IDS_SETTING_ENGLISH));
    m_CboVidemoMode.AddString(_T("PAL"));
	m_CboVidemoMode.AddString(_T("NTSC"));

	m_CboVGASize.ResetContent();
	m_CboVGASize.InsertString(0, _T("800*600 60Hz"));
	m_CboVGASize.SetItemData(0, VGA_800X600);

	m_CboVGASize.InsertString(1, _T("1024*768 60Hz"));
	m_CboVGASize.SetItemData(1, VGA_1024X768);

	m_CboVGASize.InsertString(2, _T("1280*1024 60Hz"));
	m_CboVGASize.SetItemData(2, VGA_1280X1024);

	m_CboVGASize.InsertString(3, _T("1280*720P 60Hz"));
	m_CboVGASize.SetItemData(3, VGA_1280X720P_60);

	m_CboVGASize.InsertString(4, _T("1920*1080P 60Hz"));
	m_CboVGASize.SetItemData(4, VGA_1920X1080P_60);

	m_CboVGASize.InsertString(5, _T("1280*720P 50Hz"));
	m_CboVGASize.SetItemData(5, VGA_1280X720P_50);

	m_CboVGASize.InsertString(6, _T("1920*1080P 50Hz"));
	m_CboVGASize.SetItemData(6, VGA_1920X1080P_50);

	m_CboVGASize.InsertString(7, _T("1920*1080I 60Hz"));
	m_CboVGASize.SetItemData(7, VGA_1920X1080I_60);

	m_CboVGASize.InsertString(8, _T("1920*1080I 50Hz"));
	m_CboVGASize.SetItemData(8, VGA_1920X1080I_50);

	m_CboVGASize.InsertString(9, _T("1366*768 60Hz"));
	m_CboVGASize.SetItemData(9, VGA_1366x768_60);

	m_CboVGASize.InsertString(10, _T("1440*900 60Hz"));
	m_CboVGASize.SetItemData(10, VGA_1440x900_60);

	m_CboVGASize.InsertString(11, _T("1280*800 60Hz"));
	m_CboVGASize.SetItemData(11, VGA_1280x800_60);

	m_CboVGASize.InsertString(12, _T("2560*1600 30Hz"));
	m_CboVGASize.SetItemData(12, VGA_2560x1600_30);

	m_CboVGASize.InsertString(13, _T("3840*2160 30Hz"));
	m_CboVGASize.SetItemData(13, VGA_3840x2160_30);

	m_CboVGASize.InsertString(14, _T("3840*2160 60Hz"));
	m_CboVGASize.SetItemData(14, VGA_3840x2160_60);

	m_cboPreference.AddString(GetText(IDS_DIALOG_PAGE_SYSTEM_LOWDELAY));//ʱ
	m_cboPreference.AddString(GetText(IDS_DIALOG_PAGE_SYSTEM_SMOOTH));//
	m_cboPreference.SetCurSel(0);

	int iRet = CreateChannelCombo(m_lLogonID, &m_CboChannel);
	if (iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CPageSettingSystem::LoadSurfaceResource] CreateChannelCombo failed!Ret(%d),Error(0x%08x),ID(%d)", iRet, GetLastError(), m_lLogonID);
	}
	iRet = CreateChannelCombo(m_lLogonID, &m_CboSysChannel);
	if (iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CPageSettingSystem::LoadSurfaceResource] CreateChannelCombo failed!Ret(%d),Error(0x%08x),ID(%d)", iRet, GetLastError(), m_lLogonID);
	}
	CString csTemp;
	m_cboShowNotLogonChannel.ResetContent();
	csTemp.Format("%d",0);
	m_cboShowNotLogonChannel.AddString(csTemp);
	csTemp.Format("%d",1);
	m_cboShowNotLogonChannel.AddString(csTemp);

	//ͨʱĬʾСͨŶӦĻϢûͨĬʾСĻϢ
	int iChannelNo = m_CboChannel.GetItemData(0);
	CreatePosCombo(m_lLogonID, iChannelNo, 0, &m_CboPic,1);
	/*ChannelPicNum tChannelPicNum = {0};
	iRet = DEC_ClientGetDevConfig(m_lLogonID,  iChannelNo, 0, CMD_DEC_CFG_PICNUM, &tChannelPicNum, sizeof(ChannelPicNum));
	if (iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CPageSettingSystem::LoadSurfaceResource] DEC_ClientGetDevConfig failed!Ret(%d),Error(0x%08x),ID(%d)", iRet, GetLastError(), m_lLogonID);
	}

	for (int i = 0; i < tChannelPicNum.iPicNum; ++i)
	{
		CString szTemp;
		szTemp.Format("%d", i+1);
		m_CboPic.AddString(szTemp);
	}*/

	//if (iChannelNo >=0 && iChannelNo < DEC_MAX_CHANNEL_NUM_NEW)//ͨ
	//{
	//	for (int i = 0; i < stChnNumAndMode.iLocalChnMode[iChannelNo]; ++i)
	//	{
	//		CString szTemp;
	//		szTemp.Format("%d", i+1);
	//		m_CboPic.AddString(szTemp);
	//	}
	//}
	//else if(iChannelNo >= DEC_MAX_CHANNEL_NUM_NEW)
	//{
	//	for (int i = 0; i < stChnNumAndMode.iVOChnMode[iChannelNo-DEC_MAX_CHANNEL_NUM_NEW]; ++i)
	//	{
	//		CString szTemp;
	//		szTemp.Format("%d", i+1);
	//		m_CboPic.AddString(szTemp);
	//	}
	//}
	m_CboPic.SetCurSel(0);
	//add end

	CString strTimeZone;
	for (int i = 12;i > 0;--i)
	{
		strTimeZone.Format(_T("GMT-%02d:00"),i);
		m_cboTimeZone.AddString(strTimeZone);
	}
	m_cboTimeZone.AddString(_T("GMT"));
	for (int i = 1;i <= 13;++i)
	{
		strTimeZone.Format(_T("GMT+%02d:00"),i);
		m_cboTimeZone.AddString(strTimeZone);
	}
	int iIndexSysPos = -1;
	for (int i = 1; i <= MAX_PLAN_COUNT; i++)
	{
		CString szTemp;
		szTemp.Format("%d", i);
		iIndexSysPos = m_cbbPlan.AddString(szTemp);
		m_cbbPlan.SetItemData(iIndexSysPos, i - 1);
	}

	m_cbbPlan.SetCurSel(0);

	SetDlgItemText(IDC_STATIC_SYSCHANNEL, GetText(IDS_SETTING_CHANNEL));
	SetDlgItemText(IDC_STATIC_SYSTEMSET, GetText(IDS_SETTING_SYSTEM));
	SetDlgItemText(IDC_STATIC_VGASIZE, GetText(IDS_SETTING_VGASIZE));
	SetDlgItemText(IDC_STATIC_VIDEOMODE, GetText(IDS_SETTING_VIDEOMODE));
	SetDlgItemText(IDC_STATIC_UPGRADESYSTEM, GetText(IDS_SETTING_UPGRADESYSTEM));
	SetDlgItemText(IDC_STATIC_UPGRADEWEB, GetText(IDS_SETTING_UPWEB));
	SetDlgItemText(IDC_STATIC_LANGUAGE, GetText(IDS_SETTING_LANGUAGE));
	SetDlgItemText(IDC_BUTTON_BROWSEUPGRADESYSTEM, GetText(IDS_SETTING_BROWSEPRO));
	SetDlgItemText(IDC_BUTTON_UPGRADESYSTEM, GetText(IDS_SETTING_UPGRADEPRO));
	SetDlgItemText(IDC_BUTTON_BROWSEUPGRADEWEB, GetText(IDS_SETTING_BROWSEWEB));
	SetDlgItemText(IDC_BUTTON_UPGRADEWEB, GetText(IDS_SETTING_UPGRADEWEB));

	SetDlgItemText(IDC_STATIC_PICSELECT, GetText(IDS_SETTING_SELPIC));
	SetDlgItemText(IDC_STATIC_CHANNEL, GetText(IDS_SETTING_PICCHANNEL));
	SetDlgItemText(IDC_STATIC_PIC, GetText(IDS_SETTING_PICTURE));
	SetDlgItemText(IDC_BUTTON_SETPIC, GetText(IDS_SETTING_SETSELPIC));

	SetDlgItemText(IDC_STATIC_AUDIO, GetText(IDS_SETTING_VOLUME));
	SetDlgItemText(IDC_STATIC_AUDIOSET, GetText(IDS_SETTING_VOLUMESET));
	SetDlgItemText(IDC_BUTTON_SETAUDIO, GetText(IDS_SETTING_SETVOLUME));
	SetDlgItemText(IDC_STATIC_PREFERENCE, GetText(IDS_DIALOG_PAGE_SETTINGSYSTEM));
	SetDlgItemText(IDC_CHECK_NETCUT_RESERVE_LATFRAME, GetText(IDS_DIALOG_PAGE_SETTINGSYSTEM_RESERVE_FRAME));

	SetDlgItemText(IDC_STATIC_SYSTEMTIME, GetText(IDS_STATIC_SYSTEMTIME));
	SetDlgItemText(IDC_BUTTON_TIME, GetText(IDS_BUTTON_TIME));
	SetDlgItemText(IDC_BUTTON_DEFAULT, GetText(IDS_SETTING_RESET));
	SetDlgItemText(IDC_STATIC_TIMEZONE, GetText(IDS_TIMEZONE));
	SetDlgItemText(IDC_BUTTON_SHOWVONO, GetText(IDS_SHOWVONO));


	SetDlgItemText(IDC_EDIT_FILE1, "XXX.ini");
	SetDlgItemText(IDC_EDIT_FILE2, "XXX.ini");
	SetDlgItemText(IDC_EDIT_FILE3, "XXX.ini");
	SetDlgItemText(IDC_EDIT_FILE4, "XXX.ini");
	SetDlgItemText(IDC_EDIT_SAVE_FILE, "export.box");

	m_edtOtherName.SetLimitText(DEC_LEN_64);
}

int CPageSettingSystem::Initialize(TDECPARAM* _pdecParam)
{
		
	m_pDecParam = _pdecParam;
	LoadSurfaceResource();

	UpdataCommonInfo();
	m_CboLanguage.SetCurSel(_pdecParam->m_language);
    m_CboVidemoMode.SetCurSel(_pdecParam->m_ispal);
	//add begin 20140604
	VGASize stVGASize= {0};
	stVGASize.iBuffSize = sizeof(VGASize);
	stVGASize.iChannelNo = GetComboData(&m_CboSysChannel);//(int)m_CboChannel.GetItemData(m_CboSysChannel.GetCurSel());
	if(NULL != DEC_ClientGetDevConfig)
	{
		int iRet = DEC_ClientGetDevConfig(m_lLogonID,0,0,CMD_DEC_CFG_VGA_SIZE,&stVGASize,sizeof(VGASize));
		if (iRet == 0)
		{
			for(int i = 0; i < m_CboVGASize.GetCount(); i++)
			{
				if(m_CboVGASize.GetItemData(i)==stVGASize.iVGASize)
				{
					m_CboVGASize.SetCurSel(i);
				}
			}
		}
	}

    SetDlgItemInt(IDC_EDIT_AUDIOSET ,_pdecParam->m_iVolume);
	char cCap[64] = {0};
	DEC_ClientGetCapability(m_lLogonID,cCap);
 //	if(atoi(cCap) < CAP_6)				//TC_921S2_MP֮豸֧ʾ
 	{
	//	GetDlgItem(IDC_COMBO_VGASIZE)->ShowWindow(FALSE);
	//	GetDlgItem(IDC_STATIC_VGASIZE)->ShowWindow(FALSE);
	}

	m_sldVolume.SetRange(0,100,TRUE);
	m_sldVolume.SetPos(0);
	m_sldVolume.SetLineSize(1);

	UpdataVolumeInfo();

	UpdateTimeZoneInfo();


	UpdatePlanNo();
	UpdatePlanInfo();
	UpdateShowNotOnLineChannel();
    return 0;
}

void CPageSettingSystem::UpdateTimeZoneInfo()
{
	int iTimeZone = 0 ;
	int iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_TIMEZONE, &iTimeZone, sizeof(int));
	if (ERR_SUCCESS != iRet)
	{
		AddLog(LOG_LEVEL_WARN,"[CPageSettingSystem::UpdateTimeZoneInfo] Get time zone failed!Ret(%d),Error(0x%08x),ID(%d)"
			,iRet,GetLastError(),m_lLogonID);
	}
	else
	{
		m_cboTimeZone.SetCurSel(iTimeZone + 12);
	}	
}

void CPageSettingSystem::UpdateShowNotOnLineChannel()
{
	ShowOfflineChan tShowOffLineChan;
	tShowOffLineChan.iSize = sizeof(ShowOfflineChan);
	int iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_SHOW_OFFLINE_CHAN, &tShowOffLineChan, sizeof(ShowOfflineChan));
	if (iRet < 0)
	{
		AddLog(LOG_LEVEL_ERROR,"[CPageSettingSystem::OnCbnSelchangeCboShowNotOnLine] Set failed! Error(0x%08x)",GetLastError());
		return;
	}
	m_cboShowNotLogonChannel.SetCurSel(tShowOffLineChan.iEnable);
}

void CPageSettingSystem::OnBnClickedButtonSetpic()
{
	int iChannel = GetComboData(&m_CboChannel);//(int)m_CboChannel.GetItemData(m_CboChannel.GetCurSel());
	int iPicture = GetComboData(&m_CboPic);//m_CboPic.GetCurSel();

	int iRet = DEC_SetSelectPicture(m_lLogonID, iChannel, iPicture);
	if (iRet == 0)
	{
		MessageBox(GetText(IDS_SETTING_SETOK),_T(""),MB_OK|MB_TOPMOST);
	}
}

void CPageSettingSystem::OnBnClickedButtonBrowseupgradesystem()
{
// 	CFileDialog dlgFile(TRUE, NULL, NULL, NULL, _T("Kernal update files (*.bin)|*.bin||"));
// 	CString fileName;
// 	const int c_cMaxFiles = 100;
// 	const int c_cbBuffSize = (c_cMaxFiles * (MAX_PATH + 1)) + 1;
// 	dlgFile.GetOFN().lpstrFile = fileName.GetBuffer(c_cbBuffSize);
// 	dlgFile.GetOFN().nMaxFile = c_cMaxFiles;
// 
// 	if (IDOK == dlgFile.DoModal())
// 	{
// 		m_EditUpgradeFile.SetWindowText(fileName);
// 	}
// 	fileName.ReleaseBuffer();	

	CFileDialog dlgFile(TRUE, NULL, NULL
		,OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_ENABLESIZING
		,_T("Kernal update files (*.bin)|*.bin||"));
	if(IDOK == dlgFile.DoModal())
	{
		CString fileName = dlgFile.GetPathName();
		m_EditUpgradeFile.SetWindowText(fileName); 	
	}
}

void CPageSettingSystem::OnCbnSelchangeComboChannel()
{

	int iIndex = GetComboData(&m_CboChannel);//m_CboChannel.GetCurSel();
	int iChannelNo = GetComboData(&m_CboChannel);//m_CboChannel.GetItemData(iIndex);
	////ȡͨϢ
	///*ChnNumAndMode stChnNumAndMode = {0};
	//stChnNumAndMode.iBufSize = sizeof(ChnNumAndMode);*/
	//tDevInfo tDevinfomation = {0};
	//tDevinfomation.iSize = sizeof(tDevInfo);
	////int iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_CHANN_NUM, &stChnNumAndMode, sizeof(ChnNumAndMode));
	//int iRet = DEC_ClientGetDevConfig(m_lLogonID, iChannelNo, 0, CMD_DEC_CFG_DEV_INFO, &tDevinfomation, sizeof(tDevInfo));
	//if (ERR_SUCCESS != iRet)
	//{
	//	AddLog(LOG_LEVEL_WARN,"[CPageSettingSystem::OnCbnSelchangeComboChannel] DEC_ClientGetDevConfig failed!Ret(%d),Error(0x%08x),ID(%d)", iRet, GetLastError(), m_lLogonID);
	//}
	//		
	//m_CboPic.ResetContent();

	//if (iChannelNo >=0 && iChannelNo < DEC_MAX_PHYSICAL_CHANNEL_NUM)//ͨ
	//{
	//	for (int i = 0; i < tDevinfomation.iChanNum; ++i)
	//	{
	//		CString szTemp;
	//		szTemp.Format("%d", i+1);
	//		m_CboPic.AddString(szTemp);
	//	}
	//}

 //	else if(iChannelNo >= DEC_MAX_PHYSICAL_CHANNEL_NUM)
 //	{
 //		for (int i = 0; i < tDevinfomation.iSplitChanNum; ++i)
 //		{
 //			CString szTemp;
 //			szTemp.Format("%d", i+1);
 //			m_CboPic.AddString(szTemp);
 //		}
 //	}
	DecSelectPic SelPic = {0};
	SelPic.iSize = sizeof(DecSelectPic);
	int iRet = DEC_ClientGetDevConfig(m_lLogonID, iChannelNo, 0, CMD_DEC_CFG_SELECT_PIC, &SelPic, SelPic.iSize);

	CreatePosCombo(m_lLogonID, iChannelNo, SelPic.iPicNo, &m_CboPic,1);

	UpdataCommonInfo();
	UpdataVolumeInfo();

}

void CPageSettingSystem::OnBnClickedButtonSetaudio()//demoͼʱע
{
	//int iVolume  = -1;;
	//try//ת
	//{
	//	CString strVolume ;
	//	GetDlgItem(IDC_EDIT_AUDIOSET)->GetWindowText(strVolume);
	//	iVolume = atoi(CT2CA(strVolume));
	//}
	//catch (...)
	//{
	//	MessageBox(GetText(IDS_SETTING_INVALIDPARA),_T(""),MB_OK|MB_TOPMOST);
	//	return;
	//}
	int iVolume = -1;
	iVolume = m_sldVolume.GetPos();
	int iRet = DEC_SetVolume(m_lLogonID, iVolume);
	if (iRet == 0)
	{
		MessageBox(GetText(IDS_SETTING_SETOK),_T(""),MB_OK|MB_TOPMOST);
	} 
}

void CPageSettingSystem::OnBnClickedButtonBrowseupgradeweb()
{
// 	CFileDialog dlgFile(TRUE, NULL, NULL, NULL, _T("Web update files (*.box)|*.box||"));
// 	CString fileName;
// 	const int c_cMaxFiles = 100;
// 	const int c_cbBuffSize = (c_cMaxFiles * (MAX_PATH + 1)) + 1;
// 	dlgFile.GetOFN().lpstrFile = fileName.GetBuffer(c_cbBuffSize);
// 	dlgFile.GetOFN().nMaxFile = c_cMaxFiles;
// 
// 	if (IDOK == dlgFile.DoModal())
// 	{
// 		m_EditUpgradeWebFile.SetWindowText(fileName);
// 	}
// 	fileName.ReleaseBuffer();	

	CFileDialog dlgFile(TRUE, NULL, NULL
		,OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_ENABLESIZING
		,_T("Web update files (*.box)|*.box||"));
	if(IDOK == dlgFile.DoModal())
	{
		CString fileName = dlgFile.GetPathName();
		m_EditUpgradeWebFile.SetWindowText(fileName); 	
	}
}

void CPageSettingSystem::OnBnClickedButtonUpgradesystem()
{
	if (MessageBox(GetText(IDS_SETTING_CONFIRMUPDATE), _T(""), MB_OKCANCEL + MB_ICONQUESTION) == IDOK)
	{
		int iRet;
		CString szFile;
		GetDlgItem(IDC_EDIT_UPGRADESYSTEM)->GetWindowText(szFile);
		if (szFile.Compare(_T("")) == 0)
		{
			return;
		}
		iRet = DEC_ClientUpgrade(m_lLogonID,(LPSTR)(LPCTSTR)szFile);
		if(iRet == 0)
		{
			m_dlgUpgrade.DoModal();
		}
		else if(iRet == -7)
		{
			MessageBox(GetText(IDS_SETTING_INVALIDFILE),_T(""),MB_OK|MB_TOPMOST);
		}
		else
		{
			return;
		}
	}
	else
	{
		return;
	}
}

void CPageSettingSystem::OnBnClickedButtonUpgradeweb()
{
	if (MessageBox(GetText(IDS_SETTING_CONFIRMUPDATE), _T(""), MB_OKCANCEL + MB_ICONQUESTION) == IDOK)
	{
		int iRet;
		CString szFile;
		GetDlgItem(IDC_EDIT_UPGRADEWEB)->GetWindowText(szFile);
		if (szFile.Compare(_T("")) == 0)
		{
			return;
		}
		iRet = DEC_ClientUpgradeWeb(m_lLogonID,(LPSTR)(LPCTSTR)szFile);
		if(iRet == 0)
		{
			m_dlgUpgrade.DoModal();
		}
		else if(iRet == -7)
		{
			MessageBox(GetText(IDS_SETTING_INVALIDFILE),_T(""),MB_OK|MB_TOPMOST);
		}
		else
		{
			return;
		}
	}
	else
	{
		return;
	}
}

void CPageSettingSystem::RecvUpdateMsg()
{
	if (m_dlgUpgrade.m_hWnd)
	{
		m_dlgUpgrade.EndDialog(0);
	}
}

void CPageSettingSystem::OnCbnSelchangeComboVGASize()
{
	int iRet = DEC_ClientSetVGASize(m_lLogonID, GetComboData(&m_CboSysChannel), m_CboVGASize.GetItemData(m_CboVGASize.GetCurSel()));
	if(iRet < 0)
		AddLog(LOG_LEVEL_ERROR, "SetVOSize failed, ret(%d)\n", iRet);
}

void CPageSettingSystem::OnCbnSelchangeComboVideoMode()
{
	int iRet = DEC_ClientSetTVInfo(m_lLogonID, m_CboVidemoMode.GetCurSel(), m_CboLanguage.GetCurSel());
	if(iRet <= 0)
		AddLog(LOG_LEVEL_ERROR, "Set VideoMode failed. ret(%d)\n", iRet);
}

void CPageSettingSystem::OnCbnSelchangeComboLanguage()
{
	int iRet = DEC_ClientSetTVInfo(m_lLogonID, m_CboVidemoMode.GetCurSel(), m_CboLanguage.GetCurSel());
	if(iRet <= 0)
		AddLog(LOG_LEVEL_ERROR, "Set Language failed. ret(%d)\n", iRet);
}


// ´COMBO BOXٹֵ⡣ [12/26/2011 hanyongqiang]
BOOL CPageSettingSystem::PreTranslateMessage(MSG* pMsg)
{
	// TODO: Add your specialized code here and/or call the base class
	if (pMsg->hwnd == m_CboVGASize.m_hWnd)
	{
		if (WM_MOUSEWHEEL == pMsg->message && false == m_bVGAListDown)
		{
			return TRUE;
		}
	}

	if(pMsg->message == WM_KEYDOWN && (pMsg->wParam == VK_RETURN||pMsg->wParam == VK_ESCAPE)) 
	{ 
		return true;
	}


	return CDialog::PreTranslateMessage(pMsg);
}

void CPageSettingSystem::OnCbnDropdownComboVgasize()
{
	// TODO: Add your control notification handler code here
	m_bVGAListDown = true;
}

void CPageSettingSystem::OnCbnCloseupComboVgasize()
{
	// TODO: Add your control notification handler code here
	m_bVGAListDown = false;
}

void CPageSettingSystem::OnNMCustomdrawSliderVolume(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMCUSTOMDRAW pNMCD = reinterpret_cast<LPNMCUSTOMDRAW>(pNMHDR);
	// TODO: Add your control notification handler code here
	int iVolume = m_sldVolume.GetPos();
	SetDlgItemInt(IDC_STATIC_SHOW_VOLUME,iVolume);

	*pResult = 0;
}

void CPageSettingSystem::OnCbnSelchangeComboPreference()
{
	// TODO: Add your control notification handler code here
	int iEnableValue = m_cboPreference.GetCurSel();
	int iRet = -1;
	iRet = DEC_ClientSetCommonEnable(m_lLogonID, COMMONID_PREVIEW_PREFERENCE, 0x7fffffff, iEnableValue);
	if (iRet < 0)
	{
		TRACE("Set[COMMONID_PREVIEW_PREFERENCE] fail!Return value(%d)\n",iRet);
	}
}

void CPageSettingSystem::OnBnClickedCheckNetCutReserveLastFrame()
{
	// TODO: Add your control notification handler code here
	int iEnableValue = m_chkLastFrame.GetCheck();
	int iRet = -1;
	iRet = DEC_ClientSetCommonEnable(m_lLogonID, COMMONID_NETCUT_HOLD_LASTFRAME, 0x7fffffff, iEnableValue);
	if (iRet < 0)
	{
		TRACE("Set[COMMONID_NETCUT_HOLD_LASTFRAME]fail!Return value(%d)\n",iRet);
	}
}

void CPageSettingSystem::UpdataCommonInfo()
{
	int iEnableLastFrame = -1;
	int iEnablePreference = -1;
	int iEnableHDDisPlay = -1;
	int iEnableTelnet = -1;

	int iRet = DEC_ClientGetCommonEnable(m_lLogonID, COMMONID_NETCUT_HOLD_LASTFRAME, &iEnableLastFrame, &iEnablePreference);
	if (0 == iRet)
	{	
		m_chkLastFrame.SetCheck(iEnableLastFrame);
	}
	else
	{
		TRACE("Get Common info-->Last frame fail!Return value(%d)\n",iRet);
	}

	iRet = DEC_ClientGetCommonEnable(m_lLogonID, COMMONID_PREVIEW_PREFERENCE, &iEnableLastFrame, &iEnablePreference);
	if (0 == iRet)
	{
		m_cboPreference.SetCurSel(iEnablePreference);
	}
	else
	{
		TRACE("Get Common info-->View preference fail!Return value(%d)\n",iRet);
	}

	iRet = DEC_ClientGetCommonEnableEx(m_lLogonID, COMMONID_HD_DISPLAY,0x7fffffff, &iEnableHDDisPlay);
	if (ERR_SUCCESS == iRet)
	{	
		m_chkHDDisplay.SetCheck(iEnableHDDisPlay);
	}
	else
	{
		TRACE("Get Common info-->hd display fail!Return value(%d)\n",iRet);
	}

	iRet = DEC_ClientGetCommonEnableEx(m_lLogonID, COMMONID_TELNET,0x7fffffff, &iEnableTelnet);
	if (ERR_SUCCESS == iRet)
	{	
		m_chkTelnet.SetCheck(iEnableTelnet);
	}
	else
	{
		TRACE("Get Common info-->telent fail!Return value(%d)\n",iRet);
	}

	DecChanResolutionList tChanResolution = {0};
	iRet = DEC_ClientGetDevConfig(m_lLogonID,GetComboData(&m_CboChannel),0,CMD_DEC_CFG_CHANNEL_RESOLUTIONLIST,&tChanResolution,sizeof(tChanResolution));
	if (ERR_SUCCESS == iRet)
	{
		if(tChanResolution.iResolutionNum > 0)
		{
			m_CboVGASize.ResetContent();
			for(int i = 0; i < tChanResolution.iResolutionNum; i++)
			{
				m_CboVGASize.AddString(csVGA[tChanResolution.iResolution[i]]);
				m_CboVGASize.SetItemData(i,tChanResolution.iResolution[i]);
			}
		}
	}
}

void CPageSettingSystem::UpdataVolumeInfo()
{
	int iVolume = -1;
	int iRet = DEC_GetVolume(m_lLogonID, &iVolume);
	if (0 == iRet)
	{
		m_sldVolume.SetPos(iVolume);
		SetDlgItemInt(IDC_STATIC_SHOW_VOLUME, iVolume);
	}
	else
	{
		TRACE("Set Volume info fail!Return value(%d)\n",iRet);
	}
}

void CPageSettingSystem::OnClose()
{
	// TODO: Add your message handler code here and/or call default

	if (m_dlgUpgrade.m_hWnd)
	{
		m_dlgUpgrade.EndDialog(0);
	}

	CDialog::OnClose();
}

void CPageSettingSystem::OnCbnSelchangeComboSyschannel()
{
	//int iIndex = GetComboData(&m_CboSysChannel);//m_CboSysChannel.GetCurSel();
	int iChannelNo = GetComboData(&m_CboSysChannel);//m_CboSysChannel.GetItemData(iIndex);

	if (iChannelNo >= DEC_MAX_PHYSICAL_CHANNEL_NUM)
	{
		CreateVVOInfo strCreateVVOInfo = {0};
		strCreateVVOInfo.iBufSize = sizeof(CreateVVOInfo);
		strCreateVVOInfo.iVVOChannelNo = iChannelNo;
		int iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_CREATE_VVO, &strCreateVVOInfo, sizeof(CreateVVOInfo));
		if (ERR_SUCCESS != iRet)
		{
			AddLog(LOG_LEVEL_WARN,"[CPageSettingSystem::OnCbnSelchangeComboSyschannel] Get decoder param failed!Ret(%d),Error(0x%08x),ID(%d)"
				,iRet,GetLastError(),m_lLogonID);
		}
		int iUsedNum = strCreateVVOInfo.iCols * strCreateVVOInfo.iRows;

		for (int j=0; j<iUsedNum; j++)
		{
			if (0 <= strCreateVVOInfo.iInputChannel[j] && strCreateVVOInfo.iInputChannel[j] < DEC_MAX_PHYSICAL_CHANNEL_NUM)
			{
				iChannelNo = strCreateVVOInfo.iInputChannel[j];
				break;
			}
		}

	}

	if(NULL != DEC_ClientGetDevConfig)
	{
		VGASize tVGASize= {0};
		tVGASize.iBuffSize = sizeof(VGASize);
		tVGASize.iChannelNo = GetComboData(&m_CboSysChannel);//m_CboSysChannel.GetItemData(iIndex);
		int iRet = DEC_ClientGetDevConfig(m_lLogonID,0,0,CMD_DEC_CFG_VGA_SIZE,&tVGASize,sizeof(VGASize));
		if (iRet == 0)
		{			
			for(int i = 0; i < m_CboVGASize.GetCount(); i++)
			{
				if(m_CboVGASize.GetItemData(i)==tVGASize.iVGASize)
				{
					m_CboVGASize.SetCurSel(i);
				}
			}
			
		}
		else
		{
			AddLog(LOG_LEVEL_DEBUG,"[CPageSettingSystem::OnCbnSelchangeComboSyschannel] DEC_ClientGetDevConfig failed!cmd(%d), iVGASize(%d), error(%d)",CMD_DEC_CFG_VGA_SIZE, tVGASize.iVGASize, GetLastError());
		}
	}
	//add end
}

void CPageSettingSystem::OnBnClickedButtonTime()
{
	SYSTEMTIME systime;
	GetLocalTime(&systime);

	SystemTime stMySystemTime = {0};
	stMySystemTime.iBuffsize = sizeof(SystemTime);
	stMySystemTime.iYear = (int)systime.wYear;
	stMySystemTime.iMonth = (int)systime.wMonth;
	stMySystemTime.iDay = (int)systime.wDay;
	stMySystemTime.iHour = (int)systime.wHour;
	stMySystemTime.iMin = (int)systime.wMinute;
	stMySystemTime.iSec = (int)systime.wSecond;

	DEC_ClientSetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_SYSTEM_TIME, &stMySystemTime, sizeof(SystemTime));
}

void CPageSettingSystem::OnShowWindow(BOOL bShow, UINT nStatus)
{
	CDialog::OnShowWindow(bShow, nStatus);

	if (bShow)
	{
		SetTimer(UPDATE_TIME, 1000, NULL);

		SYSTEMTIME systm;
		memset(&systm, 0, sizeof(SYSTEMTIME));
		GetLocalTime(&systm);
		m_strTime.Format(_T("%hd/%02hd/%02hd %hd:%02hd:%02hd"), systm.wYear, systm.wMonth, systm.wDay, systm.wHour, systm.wMinute, systm.wSecond);
		SetDlgItemText(IDC_STATIC_TIME, m_strTime);
		UpdateData(FALSE);
	}
	else
	{
		KillTimer(UPDATE_TIME);
	}
}

void CPageSettingSystem::OnTimer(UINT_PTR nIDEvent)
{
	if (UPDATE_TIME == nIDEvent)
	{
		SYSTEMTIME systm;
		memset(&systm, 0, sizeof(SYSTEMTIME));
		GetLocalTime(&systm);
		m_strTime.Format(_T("%hd/%02hd/%02hd %hd:%02hd:%02hd"), systm.wYear, systm.wMonth, systm.wDay, systm.wHour, systm.wMinute, systm.wSecond);
		SetDlgItemText(IDC_STATIC_TIME, m_strTime);
		UpdateData(FALSE);
	}

	CDialog::OnTimer(nIDEvent);
}

void CPageSettingSystem::OnBnClickedButtonDefault()
{
	if (MessageBox(GetText(IDS_SETTING_RECOVER), _T(""), MB_OKCANCEL +MB_ICONQUESTION + MB_TOPMOST) == IDOK)
	{
		DEC_ClientResetDefault(m_lLogonID);		
	}
}

void CPageSettingSystem::OnCbnSelchangeComboTimezone()
{
	int iTimeZone = m_cboTimeZone.GetCurSel() - 12;
	if (DEC_ClientSetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_TIMEZONE, &iTimeZone, sizeof(int)) < 0)
	{
		AddLog(LOG_LEVEL_ERROR,"[CPageSettingSystem::OnCbnSelchangeComboTimezone] Set current time zone failed! LogonID(%d)Error(0x%08x)"
			,m_lLogonID, GetLastError());
	}
}

void CPageSettingSystem::OnBnClickedButtonShowvono()
{
	int iVirtual = 0;//SDK need this ptr
	DEC_ClientSetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_DISP_VONUM, &iVirtual, 0);	
}



void CPageSettingSystem::OnCbnSelchangeComboPlan()
{
	// TODO: Add your control notification handler code here
	if (m_lLogonID < 0)
	{
		return;
	}

	UpdatePlanInfo();

}

void CPageSettingSystem::UpdatePlanNo()
{
	ApplyPlan tApply = {0};
	tApply.iSize = sizeof(ApplyPlan);
	int iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_PLANALIAS, &tApply, tApply.iSize);
	if (iRet < 0)
	{
		return;
	}
	m_cbbPlan.SetCurSel(tApply.iPlanId);
}

void CPageSettingSystem::OnBnClickedButtonPlanApply()
{
	// TODO: Add your control notification handler code here

	if (m_lLogonID < 0)
	{
		return;
	}
	ApplyPlan tApply = {0};
	tApply.iSize = sizeof(ApplyPlan);
	tApply.iPlanId = GetComboData(&m_cbbPlan);
	int iRet = DEC_ClientSetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_APPLY_PLAN, &tApply, tApply.iSize);

}

void CPageSettingSystem::OnBnClickedButtonPalnSet()
{
	// TODO: Add your control notification handler code here
	PlanAlias tAlias = {0};
	tAlias.iSize = sizeof(PlanAlias);
	tAlias.iPlanId = GetComboData(&m_cbbPlan);
	CString strAlias;
	GetDlgItemText(IDC_EDIT_PLAN_ALIAS, strAlias);
	strncpy(tAlias.cAlias, strAlias.GetBuffer(), sizeof(tAlias.cAlias) - 1);
	int iRet = DEC_ClientSetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_PLANALIAS, &tAlias, tAlias.iSize);
	if (iRet < 0)
	{
		return;
	}

}

void CPageSettingSystem::OnBnClickedButtonPlanSave()
{
	// TODO: Add your control notification handler code here

	DecPlan tPlan = {0};
	tPlan.iSize = sizeof(DecPlan);
	tPlan.iPlanId = GetComboData(&m_cbbPlan);
	int iRet = DEC_ClientSetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_SAVE_PLAN, &tPlan, tPlan.iSize);
	if (iRet < 0)
	{
		return;
	}

}

void CPageSettingSystem::UpdatePlanInfo()
{

	PlanAlias tAlias = {0};
	tAlias.iSize = sizeof(PlanAlias);
	tAlias.iPlanId = GetComboData(&m_cbbPlan);
	int iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_PLANALIAS, &tAlias, tAlias.iSize);
	if (iRet < 0)
	{
		return;
	}

	DecPlan tPlan = {0};
	tPlan.iSize = sizeof(DecPlan);
	tPlan.iPlanId = GetComboData(&m_cbbPlan);
	iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_SAVE_PLAN, &tPlan, tPlan.iSize);
	if (iRet < 0)
	{
		return;
	}
	SetDlgItemText(IDC_EDIT_PLAN_ALIAS, tAlias.cAlias);
	SetDlgItemText(IDC_EDIT_PLAN_TIME, tPlan.cSaveTime);	
}

void CPageSettingSystem::OnBnClickedButtonExport()
{
	// TODO: Add your control notification handler code here
	CString strFile1;
	CString strFile2;
	CString strFile3;
	CString strFile4;
	CString strSaveFile;

	GetDlgItemText(IDC_EDIT_FILE1, strFile1);
	GetDlgItemText(IDC_EDIT_FILE2, strFile2);
	GetDlgItemText(IDC_EDIT_FILE3, strFile3);
	GetDlgItemText(IDC_EDIT_FILE4, strFile4);
	GetDlgItemText(IDC_EDIT_SAVE_FILE, strSaveFile);

	ExportConfig tExportConfig = {0};
	tExportConfig.iSize = sizeof(ExportConfig);
	strncpy(tExportConfig.cFileList[0], strFile1.GetBuffer(),sizeof(tExportConfig.cFileList[0]) - 1);
	strncpy(tExportConfig.cFileList[1], strFile2.GetBuffer(),sizeof(tExportConfig.cFileList[1]) - 1);
	strncpy(tExportConfig.cFileList[2], strFile3.GetBuffer(),sizeof(tExportConfig.cFileList[2]) - 1);
	strncpy(tExportConfig.cFileList[3], strFile4.GetBuffer(),sizeof(tExportConfig.cFileList[3]) - 1);
	strncpy(tExportConfig.cFileOut, strSaveFile.GetBuffer(),sizeof(tExportConfig.cFileOut) - 1);
	for (int i= 0; i < 4; i++)
	{
		if (strlen(tExportConfig.cFileList[i])  > 0)
		{
			tExportConfig.iCount++;
		}
		else
		{
			break;
		}
	}

	DecPlan tPlan = {0};
	tPlan.iSize = sizeof(DecPlan);
	tPlan.iPlanId = GetComboData(&m_cbbPlan);
	int iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_EXPORT_CONFIG, &tExportConfig, tExportConfig.iSize);

}

void CPageSettingSystem::OnCbnSelchangeCboShowNotOnLine()
{
	ShowOfflineChan tShowOffLineChan;
	tShowOffLineChan.iSize = sizeof(ShowOfflineChan);
	tShowOffLineChan.iEnable = m_cboShowNotLogonChannel.GetCurSel();
	int iRet = DEC_ClientSetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_SHOW_OFFLINE_CHAN, &tShowOffLineChan, sizeof(ShowOfflineChan));
	if (iRet < 0)
	{
		AddLog(LOG_LEVEL_ERROR,"[CPageSettingSystem::OnCbnSelchangeCboShowNotOnLine] Set failed! Error(0x%08x)",GetLastError());
	}
}

void CPageSettingSystem::OnParamChangeNotify(_CHANGE_PARAM_NOTIFY_DATA* pData)
{
	switch(pData->m_iMsg)
	{
	case DEC_PARACHANGE_TVINFO:
		{
			/*TDECPARAM* pdecParam =(TDECPARAM*) pData->tParam.tDecParam;
			m_CboLanguage.SetCurSel(pdecParam->m_language);
			m_CboVidemoMode.SetCurSel(pdecParam->m_ispal);*/
		}
		break;
	case DEC_PARACHANGE_TELNET:
	case DEC_PARACHANGE_HD_DISPLAY:
	case DEC_PARACHANGE_PREFERENCE:
	case DEC_PARACHANGE_RESEVELASTFRAME:
		UpdataCommonInfo();
		break;
	default:
		break;
	}
}
void CPageSettingSystem::OnMainNotify(_MAIN_NOTIFY_DATA* _pData)
{
	int iType = _pData->m_iMsg;
	int iID = _pData->m_lID;
	switch(iType)
	{
	case DEC_WCM_DEC_REBOOTTRADE:
		{
			//0Ԥ1ɹ2ʧ
			CString info;
			if(NOTIFY_SUCCESS == _pData->tParam.tRebootTradeResult.iResult)
			{
				info = GetTextByLan("ҳɹ","Reboot trade success");
			}
			else if(NOTIFY_FAILD == _pData->tParam.tRebootTradeResult.iResult)
			{
				info = GetTextByLan("ʧܣ","Reboot trade faild");
			}
			SetDlgItemText(IDC_STATIC_INFO,info);
			break;
		}
	default:
		break;
	}
}

void CPageSettingSystem::OnBnClickedCheck4kHdDisplay()
{
	// TODO: Add your control notification handler code here
	if (MessageBox(GetTextByLan("4K豸Чȷ","Set 4K will reboot device,Click ok to continue"), _T(""), MB_OKCANCEL +MB_ICONQUESTION + MB_TOPMOST) == IDOK)
	{
		int iEnableValue = m_chkHDDisplay.GetCheck();
		int iRet = -1;
		iRet = DEC_ClientSetCommonEnable(m_lLogonID, COMMONID_HD_DISPLAY, 0x7fffffff, iEnableValue);
		if (iRet != ERR_SUCCESS)
		{
			TRACE("Set[COMMONID_HD_DISPLAY]fail!Return value(%d)\n",iRet);
		}
	}else{
		UpdataCommonInfo();
	}
}

void CPageSettingSystem::OnBnClickedBtnRebootrade()
{
	// TODO: Add your control notification handler code here
	int iRet = DEC_ClientSendCommand(m_lLogonID, 0, 0, DEC_COMMAND_REBOOTTRADE, NULL, 0);
	if (ERR_SUCCESS != iRet)
	{
		AddLog(LOG_LEVEL_ERROR, "[CPageSettingSystem::OnBnClickedBtnRebootrade] DEC_ClientSendCommand Failed!\
								Ret(%d),CMDID(DEC_COMMAND_REBOOTTRADE)",iRet);
	}

}

void CPageSettingSystem::OnBnClickedCheckTelnet()
{
	// TODO: Add your control notification handler code here
	int iEnableValue = m_chkTelnet.GetCheck();
	int iRet = -1;
	iRet = DEC_ClientSetCommonEnable(m_lLogonID, COMMONID_TELNET, 0x7fffffff, iEnableValue);
	if (iRet != ERR_SUCCESS)
	{
		AddLog(LOG_LEVEL_ERROR, "[CPageSettingSystem::OnBnClickedCheckTelnet] DEC_ClientSetCommonEnable Failed!\
								Ret(%d),CMDID(COMMONID_TELNET)",iRet);
	}
}

